﻿# -*- coding: utf-8 -*-

# 获取客户端引擎API模块
import mod.client.extraClientApi as clientApi
# 获取客户端system的基类ClientSystem
ClientSystem = clientApi.GetClientSystemCls()
import modConfig
from modConfig import ProgressState

compFactory = clientApi.GetEngineCompFactory()

# 在modMain中注册的Client System类
class VirtualWorldAnimClientSystem(ClientSystem):

	# 客户端System的初始化函数
	def __init__(self, namespace, systemName):
		# 首先初始化TutorialClientSystem的基类ClientSystem
		super(VirtualWorldAnimClientSystem, self).__init__(namespace, systemName)
		print "==== ClientSystem Init ===="
		self.gameComp = compFactory.CreateGame(clientApi.GetLevelId())
		self.playerId = clientApi.GetLocalPlayerId()
		self.virtualWorldComp = compFactory.CreateVirtualWorld(clientApi.GetLevelId())
		self.playerMoveTimer = None
		#是否存在虚拟世界
		self.isExistVirtualWorld = False
		# 移动模型id
		self.moveObjId = None
		# 静止模型id
		self.staticObjId = None
		# 静止模型初始位置
		self.staticObjPos = (0.5, 0, -10.5)
		# 帧数统计
		self.tickCount = 0
		# 游戏状态
		self.gameState = ProgressState.BeforeInit
		# 起点坐标
		self.startPoint = (-5, 0, -5)
		# 终点坐标
		self.endPoint = (0, 0, -10)
		self.ListenEvent()

	def ListenEvent(self):

		self.ListenForEvent(modConfig.engineSpace, modConfig.engineName, 'OnScriptTickClient', self, self.OnScriptTickClient)

		self.ListenForEvent(modConfig.ModName,modConfig.ServerSystemName,"CreateVirtualWorld",self,self.CreateVirtualWorld)
		self.ListenForEvent(modConfig.engineSpace,modConfig.engineName,"UiInitFinished",self,self.UiInitFinished)

	def OnScriptTickClient(self):
		self.tickCount = self.tickCount + 1
		if self.tickCount % 3 == 0:
			self.tickCount = 0
			if self.gameState == ProgressState.BeforeInit:
				return
			self.StateModify()

	def StateModify(self):
		if self.moveObjId is None:
			return

		if self.gameState == ProgressState.MoveToEnd:
			self.MoveToEndOperate()
		elif self.gameState == ProgressState.ReturnToStart:
			self.ReturnToStartOperate()

	def MoveToEndOperate(self):
		currentPos = self.virtualWorldComp.ModelGetPos(self.moveObjId)
		if currentPos == self.endPoint:
			self.StartAttackBlock(self.moveObjId)
			self.StartAttackBlock(self.staticObjId)

	def ReturnToStartOperate(self):
		currentPos = self.virtualWorldComp.ModelGetPos(self.moveObjId)
		if currentPos == self.startPoint:
			self.SetModelMoveToTarget()

	def showLeftMsg(self, message, color):
		comp = compFactory.CreateTextNotifyClient(self.playerId)
		comp.SetLeftCornerNotify("§" + color + "[client]" + message)

	def UiInitFinished(self, data):
		self.showLeftMsg("聊天窗口指令：","a")
		self.showLeftMsg("关闭虚拟世界输入：关闭虚拟世界","b")
		self.showLeftMsg("创建虚拟世界输入：虚拟世界","b")

		# 创建虚拟世界
		# self.gameComp.AddTimer(0.1, self.CreateWorld)


	def CreateVirtualWorld(self, data):
		state = data['state']
		if state == "create":
			self.showLeftMsg("创建虚拟世界","6")
			self.CreateWorld()
		elif state == "close":
			result = self.virtualWorldComp.VirtualWorldDestroy()
			#重置环境
			if result:
				self.isExistVirtualWorld = False
				self.showLeftMsg("关闭虚拟世界","6")

	def CreateWorld(self):
		result = self.virtualWorldComp.VirtualWorldCreate()		
		#判断是否创建成功
		if result:
			self.isExistVirtualWorld = True
		else:
			self.showLeftMsg("Create false",'c')
			return
		
		#设置相机
		self.virtualWorldComp.CameraSetPos((0, 15, 5))
		self.virtualWorldComp.CameraLookAt((0, 0, -13), (0, 1, 0))

		self.virtualWorldComp.VirtualWorldSetSkyTexture("textures/vsky", 0)
		self.virtualWorldComp.VirtualWorldSetCollidersVisible(True)		

		#创建文字面板
		comp = clientApi.GetEngineCompFactory().CreateTextBoard(self.playerId)
		boardId = comp.CreateTextBoardInWorld("欢迎来到虚拟世界!",(0.5, 0.0, 1.0, 1.0),(1, 1, 1, 1),True)
		comp.SetBoardPos(boardId,(0, 8, -10))
		comp.SetBoardScale(boardId,(8, 8))
		self.virtualWorldComp.MoveToVirtualWorld(clientApi.GetMinecraftEnum().VirtualWorldObjectType.Textboard,boardId)

		#创建地形
		mid = self.virtualWorldComp.ModelCreateObject("qd_shilaimu_0_0", "")
		self.virtualWorldComp.ModelSetPos(mid, (0, -2, -12))
		self.virtualWorldComp.ModelSetRot(mid, (0, 180, 0))
		self.virtualWorldComp.ModelSetScale(mid, (30.0, 2.0, 30.0))

		# 创建需移动模型
		objId = self.virtualWorldComp.ModelCreateObject('datiangou', 'run')
		self.virtualWorldComp.ModelSetPos(objId, self.startPoint)
		self.virtualWorldComp.ModelSetRot(objId, (0, 180, 0))
		self.virtualWorldComp.ModelSetScale(objId, (0.8, 0.8, 0.8))
		# self.virtualWorldComp.ModelSetBoxCollider(objId, (2.0, 2.0, 2.0), (0.0, 0.0, 0.0))
		# self.virtualWorldComp.ModelUpdateAnimationMolangVariable(objId, {"variable.state": 2, "variable.liedownamount": 1})
		self.moveObjId = objId

		# 创建idle状态模型
		objId = self.virtualWorldComp.ModelCreateObject('datiangou', 'run')
		self.virtualWorldComp.ModelSetPos(objId, (1, 0, -11))
		self.virtualWorldComp.ModelSetRot(objId, (0, -45, 0))
		self.virtualWorldComp.ModelSetScale(objId, (0.8, 0.8, 0.8))
		self.staticObjId = objId

		self.SetModelMoveToTarget()

	def SetModelMoveToTarget(self):
		"""
		@description 将虚拟模型从起始点移动至终点
		"""
		if not self.moveObjId:
			return

		result = self.virtualWorldComp.ModelMoveTo(self.moveObjId, self.endPoint, 3.0)
		if result:
			self.virtualWorldComp.ModelSetRot(self.moveObjId, (0, 135, 0))
			self.gameState = ProgressState.MoveToEnd

	def SetModelReturnBornPoint(self):
		"""
		@description 将虚拟模型从终点移回起始点
		"""
		if not self.moveObjId:
			return

		result = self.virtualWorldComp.ModelMoveTo(self.moveObjId, self.startPoint, 3.0)
		if result:
			self.virtualWorldComp.ModelSetRot(self.moveObjId, (0, -45, 0))
			self.gameState = ProgressState.ReturnToStart

	def StartAttackBlock(self, objId):
		"""
		@description 播放虚拟模型攻击动画
		"""
		if not objId:
			return

		self.virtualWorldComp.ModelStopAnimation(objId, 'run')
		self.virtualWorldComp.ModelPlayAnimation(objId, 'fengxi', False)

		self.gameState = ProgressState.AttackBlock
		self.gameComp.AddTimer(1.2, self.StopAttackBlock, objId)

	def StopAttackBlock(self, objId):
		"""
		@description 停止播放虚拟模型攻击动画
		"""
		if not objId:
			return

		self.virtualWorldComp.ModelStopAnimation(objId, 'fengxi')
		self.virtualWorldComp.ModelPlayAnimation(objId, 'run', True)
		if objId == self.moveObjId:
			self.SetModelReturnBornPoint()

		

