# -*- coding: utf-8 -*-
# by 7stars
import server.extraServerApi as serverApi
from random import random
CF = serverApi.GetEngineCompFactory()
levelId = serverApi.GetLevelId()
Game = CF.CreateGame(levelId)
CMD = CF.CreateCommand(levelId).SetCommand

class ServerSystem(serverApi.GetServerSystemCls()):
    def __init__(self, namespace, systemName):
        super(ServerSystem, self).__init__(namespace, systemName)
        EN, ESN = serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName()
        self.ListenForEvent(EN, ESN, 'ServerItemTryUseEvent', self, self.ServerItemTryUseEvent)
        self.ListenForEvent(EN, ESN, 'ItemReleaseUsingServerEvent', self, self.ItemReleaseUsingServerEvent)
        self.ListenForEvent('customRangedWeapon', 'ClientSystem', 'ClientEvent', self, self.OnGetClientEvent)
        # 保存装载弩的计时器，用于播放音效，以及用于判断玩家松开过一次右键
        self.crossbowTimer = {}

    # 该方法也会被客户端调用
    def CancelCrossbowTimer(self, playerId):
        Game.CancelTimer(self.crossbowTimer.pop(playerId, None))

    def OnGetClientEvent(self, args):
        funcArgs = args.get('args', ({},))
        if len(funcArgs)==1 and isinstance(funcArgs[0], dict):
            funcArgs[0]['__id__'] = args['__id__']
        getattr(self, args['funcName'])(*funcArgs, **args.get('kwargs', {}))

    def DeleteItem(self, playerId, itemName):
        comp = CF.CreateItem(playerId)
        for slotPos in xrange(36):
            slotData = comp.GetPlayerItem(0, slotPos)
            if slotData and slotData['newItemName']==itemName:
                return comp.SetInvItemNum(slotPos, slotData['count']-1)

    def ReduceDurability(self, playerId, itemDict):
        # 根据耐久附魔的等级决定是否扣除1点耐久
        if random() <= 1.0/(1+next((e[1]for e in itemDict.get('enchantData', ())if e[0]==17), 0)):
            # 如果没耐久了，则清除物品并播放损坏音效
            if itemDict['durability']==1:
                CMD('replaceitem entity @s slot.weapon.mainhand 0 air', playerId)
                CMD('playsound random.break @s', playerId)
            else:
                CF.CreateItem(playerId).SetItemDurability(2, 0, itemDict['durability']-1)

    def ServerItemTryUseEvent(self, args):
        if args['itemName'][:34]!='customrangedweapon:custom_crossbow':
            return
        playerId = args['playerId']
        comp = CF.CreateItem(playerId)
        itemDict = comp.GetPlayerItem(2, 0, True)
        # 移除这两个键，防止生成物品时高级附魔被刷掉
        itemDict.pop('enchantData', None)
        itemDict.pop('modEnchantData', None)
        if args['itemName']=='customrangedweapon:custom_crossbow':
            itemDict['newItemName'] = 'customrangedweapon:custom_crossbow_charged'
            if playerId in self.crossbowTimer:
                CMD('playsound crossbow.loading.middle @a ~~0.4~', playerId)
                if Game.GetPlayerGameType(playerId)!=1\
                and not self.DeleteItem(playerId, 'customrangedweapon:projectile'):
                    return CMD('title @s actionbar 背包里没有自定义箭', playerId)
                comp.SpawnItemToPlayerCarried(itemDict, playerId)
            else:
                CMD('playsound crossbow.loading.start @a ~~0.4~', playerId)
                def middle():
                    CMD('playsound crossbow.loading.middle @a ~~0.4~', playerId)
                    self.CancelCrossbowTimer(playerId)
                    self.crossbowTimer[playerId] = None
                self.crossbowTimer[playerId] = Game.AddTimer(0.5, middle)
        elif playerId not in self.crossbowTimer:
            itemDict['newItemName'] = 'customrangedweapon:custom_crossbow'
            comp.SpawnItemToPlayerCarried(itemDict, playerId)
            Game.GetPlayerGameType(playerId)!=1 and self.ReduceDurability(playerId, itemDict)
            pos = CF.CreatePos(playerId).GetPos()
            CF.CreateProjectile(levelId).CreateProjectileEntity(playerId, 'customrangedweapon:custom_arrow',
            {'position': (pos[0], pos[1]-0.1, pos[2]), 'power': 5.0})
            CMD('playsound crossbow.shoot @a ~~0.4~', playerId)

    def ItemReleaseUsingServerEvent(self, args):
        playerId, itemDict = args['playerId'], args['itemDict']
        # 如果是未装载的弩，则取消定时器后返回
        if itemDict['newItemName']=='customrangedweapon:custom_crossbow':
            return self.CancelCrossbowTimer(playerId)
        # 如果右键时间太短，或不是自定义弓则直接返回
        if args['maxUseDuration']-args['durationLeft']<3\
        or itemDict['newItemName']!='customrangedweapon:custom_bow':
            return
        # 如果不是创造模式
        if Game.GetPlayerGameType(playerId)!=1:
            if not self.DeleteItem(playerId, 'customrangedweapon:projectile'):
                return CMD('title @s actionbar 背包里没有自定义箭', playerId)
            args['changeItem'] = True
            self.ReduceDurability(playerId, itemDict)
        # 计算power并发射箭矢，算法和原版代码一致
        power = (args['maxUseDuration']-args['durationLeft'])/20.0
        pos = CF.CreatePos(playerId).GetPos()
        CF.CreateProjectile(levelId).CreateProjectileEntity(playerId, 'customrangedweapon:custom_arrow',
        {'position': (pos[0], pos[1]-0.1, pos[2]), 'power': max(5.0*min(power*(power+2)/3, 1.0), 0.5)})
        CMD('playsound random.bow @a ~~0.4~', playerId)