# -*- coding: utf-8 -*-
# by 7stars
import client.extraClientApi as clientApi
CF = clientApi.GetEngineCompFactory()
PID = clientApi.GetLocalPlayerId()
levelId = clientApi.GetLevelId()

class ClientSystem(clientApi.GetClientSystemCls()):
    def __init__(self, namespace, systemName):
        super(ClientSystem, self).__init__(namespace, systemName)
        EN, ESN = clientApi.GetEngineNamespace(), clientApi.GetEngineSystemName()
        self.ListenForEvent(EN, ESN, 'AddPlayerCreatedClientEvent', self, self.AddPlayerCreatedClientEvent)
        self.ListenForEvent(EN, ESN, 'TapOrHoldReleaseClientEvent', self, self.OnRightClickRelease)
        self.ListenForEvent(EN, ESN, 'RightClickReleaseClientEvent', self, self.OnRightClickRelease)

    def CallServer(self, funcName, *args, **kwargs):
        data = {'funcName': funcName}
        if args: data['args'] = args
        if kwargs: data['kwargs'] = kwargs
        self.NotifyToServer('ClientEvent', data)

    def OnRightClickRelease(self, args):
        self.CallServer('CancelCrossbowTimer', PID)

    def AddPlayerCreatedClientEvent(self, args):
        comp = CF.CreateActorRender(args['playerId'])
        itemName = 'customrangedweapon:custom_bow'
        def GetTestMolang(itemName):
            # 当手持itemName，并且正在右键使用，该molang会通过
            return "query.is_item_name_any('slot.weapon.mainhand', '"+itemName+"') && query.item_remaining_use_duration"
        # 给自定义弓添加第三人称动画
        comp.AddPlayerAnimation(itemName, 'animation.player.bow_equipped')
        comp.AddPlayerAnimationIntoState('root', 'third_person', itemName, GetTestMolang(itemName))
        # 上面两句的作用是，当Molang通过，就播放动画animation.player.bow_equipped
        itemName = 'customrangedweapon:custom_crossbow'
        # 给自定义弩添加第一人称动画
        comp.AddPlayerAnimation(itemName, 'animation.player.first_person.crossbow_equipped')
        comp.AddPlayerAnimationIntoState('root', 'first_person', itemName, GetTestMolang(itemName))
        # 给自定义弩添加第三人称动画
        comp.AddPlayerAnimation(itemName+'_third', 'animation.player.crossbow_equipped')
        comp.AddPlayerAnimationIntoState('root', 'third_person', itemName+'_third', GetTestMolang(itemName))
        # 给已装填的自定义弩添加第三人称动画
        itemName += '_charged'
        comp.AddPlayerAnimation(itemName, 'animation.player.crossbow_hold')
        comp.AddPlayerAnimationIntoState('root', 'third_person', itemName, GetTestMolang(itemName)[:-37])
        comp.RebuildPlayerRender()