# -*- coding: utf-8 -*-

import mod.server.extraServerApi as serverApi
ServerSystem = serverApi.GetServerSystemCls()
from Scripts.modCommon import modConfig
# 用来打印规范格式的log
from mod_log import logger
# 获取组件工厂，用来创建组件
compFactory = serverApi.GetEngineCompFactory()

class CustomShieldItemModServerSystem(ServerSystem):
    def __init__(self, namespace, systemName):
        ServerSystem.__init__(self, namespace, systemName)
        logger.info("===== CustomShieldItemModServerSystem Listen =====")
        self.ListenEvent()

        # 在类初始化的时候开始监听
    def ListenEvent(self):
        self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "ServerChatEvent", self, self.OnServerChat)

        # 在Destroy中调用反注册一些事件
    def UnListenEvent(self):
        self.UnListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "ServerChatEvent", self, self.OnServerChat)

        # 在清除该system的时候调用取消监听事件
    def Destroy(self):
        logger.info("===== CustomShieldItemModServerSystem Destroy =====")
        self.UnListenEvent()

    def OnServerChat(self, args):
        message = args["message"]
        playerId = args["playerId"]
        if message == "gg":
            #输入gg，给一把盾
            itemDict1 = {
                'itemName': 'customshield:test_shield',
                'count': 1,
                'shieldDefenceAngleLeft':-60,
                'shieldDefenceAngleRight':70
            }
            print "OnServerChat", itemDict1
            comp = serverApi.GetEngineCompFactory().CreateItem(playerId)
            print comp.SpawnItemToPlayerInv(itemDict1, playerId)
        