# -*- coding: utf-8 -*-

import mod.client.extraClientApi as clientApi
ClientSystem = clientApi.GetClientSystemCls()
from Scripts.modCommon import modConfig
# 用来打印规范的log
from mod_log import logger
# 获取组件工厂，用来创建组件
compFactory = clientApi.GetEngineCompFactory()

class CustomShieldItemModClientSystem(ClientSystem):

    def __init__(self, namespace, systemName):
        ClientSystem.__init__(self, namespace, systemName)
        logger.info("===== Client Listen =====")
        self.ListenEvent()

    # 监听引擎和服务端脚本的事件
    def ListenEvent(self):
        self.ListenForEvent(clientApi.GetEngineNamespace(), clientApi.GetEngineSystemName(), "AddPlayerCreatedClientEvent", self, self.OnAddPlayerCreatedClientEvent)

    # 取消监听引擎和服务端脚本事件
    def UnListenEvent(self):
        self.UnListenForEvent(clientApi.GetEngineNamespace(), clientApi.GetEngineSystemName(), "AddPlayerCreatedClientEvent", self, self.OnAddPlayerCreatedClientEvent)

    # 监听的"AddPlayerCreatedClientEvent"事件表明用户渲染资源加载完毕
    # 此时可以使用sdk中的一些接口去进行一些渲染资源添加(如动画资源)相关的操作
    def OnAddPlayerCreatedClientEvent(self, args):
        playerId = args.get('playerId', None)
        if playerId is not None:
            self.AddShieldAnimationCfgForPlayer(playerId)

    # 给玩家加上自定义盾牌相关动画及动画控制状态
    def AddShieldAnimationCfgForPlayer(self, playerId):
        animaComp = clientApi.GetEngineCompFactory().CreateActorRender(playerId)
        # 添加激活盾牌时玩家的动作
        # animationKey需要唯一
        # animationName复用了原版的
        # 如果需要用自定义动作也可以参考player.animation.json编写新的动作
        animaComp.AddPlayerAnimation("shield_block_main_hand_test", "animation.player.shield_block_main_hand")
        animaComp.AddPlayerAnimation("shield_block_off_hand_test", "animation.player.shield_block_off_hand")
        # blocking状态，并且左手上不是原版盾牌与自定义盾牌，并且主手是我们的自定义盾牌
        animaComp.AddPlayerAnimationIntoState("root", "third_person", "shield_block_main_hand_test", "query.blocking && query.get_equipped_item_name('off_hand') != 'shield' && !query.get_equipped_item_is_netease_shield('off_hand') && query.get_equipped_item_full_name == 'customshield:test_shield'")
        # blocking状态，并且左手是我们的自定义盾牌
        animaComp.AddPlayerAnimationIntoState("root", "third_person", "shield_block_off_hand_test", "query.blocking && query.get_equipped_item_full_name('off_hand') == 'customshield:test_shield'")
        animaComp.RebuildPlayerRender()