# -*- coding: utf-8 -*-

import server.extraServerApi as serverApi
compFactory = serverApi.GetEngineCompFactory()
ServerSystem = serverApi.GetServerSystemCls()
from mod_log import engine_logger as logger
import config

# 本Mod设计一个展示了一个自定义成就系统的使用方法
# root0 是在json中定义了自定义成就系统里面的预设击杀生物事件，目标为击杀10头牛
# child0 是在json定义了自定义成就系统里面的预设获得物品事件，目标为获得一把锋利度为1的钻石剑，该节点设置为隐藏，当该节点完成时才会展示出来
# root1、child1、child2 定义的是一种击杀混合种类生物的事件，具体的信息存储和监听触发可参考代码
class AchievementServerSystem(ServerSystem):
    def __init__(self, namespace, systemName):
        ServerSystem.__init__(self, namespace, systemName)
        print "AchievementServerSystem Listen"
        self.levelId = serverApi.GetLevelId()
        # 获取本地存储的各节点目标，该Mod里面设计了一种混合击杀的成就节点，具体的目标信息由此获取
        self.mNodeDetail = config.NodeDetail
        # 存储需要开发者添加进度和监测的节点
        self.mNodeList = config.NodeList
        # 存储根据mNodeDetail整理出来的Map，开发者使用该方法提高监测效率
        self.mCheckMap = self.GenerateGoalMap()
        # 存储玩家的进度的，当玩家加入时会自动获取一份
        self.mProgress = {}
        # 本地维护一份玩家的成就节点击杀生物的数据 eg "playerId" :{ "root" : {"minecraft:cow": 2, "minecraft:cat": 3} ...}
        self.mLocalData = {}
        self.ListenEvent()

    # 监听事件
    def ListenEvent(self):
        self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "ClientLoadAddonsFinishServerEvent", self, self.OnClientAddonsFinish)
        self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "MobDieEvent", self, self.KillCheck)
        self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "PlayerLeftEvent", self, self.PlayerExit)

    # 当客户端加载完成的时候，读取存储信息并做初始化
    # 开发者也可不存储进度数据，当达成就进度大于或等于到目标值的时候，调用AddNodeProgress接口返回False
    # 如果访问接口频率过高，建议开发者按照下面方式维护一份本地进度，自行判断成就是否达成减轻服务器处理压力
    def OnClientAddonsFinish(self, args):
        comp = serverApi.GetEngineCompFactory().CreateAchievement(self.levelId)
        playerId = args["playerId"]
        # 读取存档数据覆盖localData
        ExtraDataComp = serverApi.GetEngineCompFactory().CreateExtraData(playerId)
        self.mLocalData[playerId] = ExtraDataComp.GetExtraData(playerId + "LocalData")
        # 如果获取不到存储数据做一个初始化
        if not self.mLocalData[playerId]:
            self.mLocalData[playerId] = {}
            for node in self.mNodeDetail:
                if node not in self.mLocalData[playerId]:
                    self.mLocalData[playerId][node] = {}
                for target in self.mNodeDetail[node]["targetEntity"]:
                    self.mLocalData[playerId][node][target] = 0
        if playerId not in self.mProgress:
            self.mProgress[playerId] = {}
        for node in self.mNodeDetail:
            nodeprogress = comp.GetNodeDetailInfo(playerId, node)
            self.mProgress[playerId][node] = nodeprogress["progress"]

    # 触发了击杀事件，检查是否是目标生物
    def KillCheck(self,args):
        if not self.mProgress.has_key(args["attacker"]):
            return
        comp = serverApi.GetEngineCompFactory().CreateEngineType(args["id"])
        entityType = comp.GetEngineTypeStr()
        logger.info("被击杀的生物为%s",entityType)
        for goalEntity in self.mCheckMap:
            if goalEntity == entityType:
                for node in self.mCheckMap[goalEntity]:
                    logger.info("监测到该节点为目标节点%s",node)
                    self.AddProgress(args["attacker"], node, entityType)
                break

    def AddProgress(self, playerId, node, entity):
        # 检查节点进度在添加前已经达成则返回False，如果已经达成该节点目标怪物的数量也返回False
        if self.mProgress[playerId][node] >= self.mNodeDetail[node]["goalNumber"] \
                or self.mLocalData[playerId][node][entity] >= self.mNodeDetail[node]["targetEntity"][entity]:
            return False
        import mod.server.extraServerApi as serverApi
        comp = serverApi.GetEngineCompFactory().CreateAchievement(self.levelId)
        # 增加该玩家成就进度：
        if comp.AddNodeProgress(playerId, node, 1):
            self.mLocalData[playerId][node][entity] += 1

    # 为需要监听的目标生物建立一个map提高监听到生物死亡的时候的遍历速度，eg {"minecraft:cow" : [N1,N2] , "minecraft:cat" : N2}
    def GenerateGoalMap(self):
        tempMap = {}
        for node in self.mNodeDetail:
            for target in self.mNodeDetail[node]["targetEntity"]:
                if target not in tempMap:
                    tempMap[target] = []
                tempMap[target].append(node)
        return tempMap

    def PlayerExit(self,args):
        playerId = args["playerId"]
        ExtraDataComp = compFactory.CreateExtraData(playerId)
        if self.mProgress[playerId]:
            ExtraDataComp.SetExtraData(playerId + "LocalData", self.mProgress[playerId])
        ExtraDataComp.SaveExtraData()

    # ScriptTickServerEvent的回调函数，会在引擎tick的时候调用，1秒30帧（被调用30次）
    def OnTickServer(self):
        """
        Driven by event, One tick way
        """
        pass

    # 这个Update函数是基类的方法，同样会在引擎tick的时候被调用，1秒30帧（被调用30次）
    def Update(self):
        """
        Driven by system manager, Two tick way
        """
        pass

    def Destroy(self):
        pass