# -*- coding: utf-8 -*-
#
import mod.server.extraServerApi as serverApi

compFactory = serverApi.GetEngineCompFactory()

class CustomEntityServerSystem(serverApi.GetServerSystemCls()):
	def __init__(self, namespace, name):
		super(CustomEntityServerSystem, self).__init__(namespace, name)
		self.ListenEvent()

	def ListenEvent(self):
		self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "AddServerPlayerEvent",
							self, self.OnAddServerPlayerEvent)
		self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "ServerChatEvent",
							self, self.OnServerChatEvent)
		self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "PlayerAttackEntityEvent",
							self, self.OnPlayerAttackEntityServerEvent)


	def createEntity(self, playerId):
		comp = compFactory.CreatePos(playerId)
		pos = comp.GetPos()
		pos = (pos[0] + 1, pos[1], pos[2] + 1)
		comp = compFactory.CreateRot(playerId)
		rot = comp.GetRot()
		result = self.CreateEngineEntityByTypeStr("netease:squirrel", pos, rot)

	def OnServerChatEvent(self, args):
		# 聊天框输入summon召唤自定义松鼠
		if args['message'] == 'summon':
			# 测试创建自定义生物实体
			self.createEntity(args['playerId'])

	def OnAddServerPlayerEvent(self, args):
		# 玩家进入世界时创建自定义生物
		comp = compFactory.CreateGame(serverApi.GetLevelId())
		comp.AddTimer(3.0, self.createEntity, args['id'])
		
	def OnPlayerAttackEntityServerEvent(self, args):
		# 玩家攻击松鼠改变松鼠的材质
		victimId = args['victimId']
		self.BroadcastToAllClient("ChangeMaterial", {"entityId": victimId })
