# -*- coding: utf-8 -*-

import mod.server.extraServerApi as serverApi
ServerSystem = serverApi.GetServerSystemCls()
compFactory = serverApi.GetEngineCompFactory()

# 用来本地调试，设为True时，可以在本地简单测试添加获取成就进度
DEBUG = False

from mod_log import engine_logger as logger

#该模板提供了一个用extra数据存储混合击杀的成就示例
class LobbyAchievementServerSystem(ServerSystem):
    def __init__(self, namespace, systemName):
        ServerSystem.__init__(self, namespace, systemName)

        print "===== lobbyAchievementServerSystem init ====="

        if not DEBUG:
            if serverApi.GetPlatform() != -1:
                # 非联机大厅环境下，compFactory.CreateHttp会返回None
                # 如果该组件在联机大厅外也可用，需要对不同平台做不同处理
                print "非联机大厅！"
                return

        # 存储所有成就ID的list
        self.mNodeList = ["N1","N2","N3"]
        # 存储所有成就的目标，包括目标数量和目标击杀生物数量,可另外用文件存储，因为示例模板的成就数量少就直接写在同文件下了
        self.mNodeDetail = {
            "N1": {
                "goalNumber" : 10,
                "targetEntity":{
                    "minecraft:cow" : 4,
                    "minecraft:sheep" : 6
                }
            },
            "N2": {
                "goalNumber": 6,
                "targetEntity": {
                    "minecraft:cow": 3,
                    "minecraft:cat": 3
                }
            },
            "N3": {
                "goalNumber": 1,
                "targetEntity": {
                    "minecraft:cat": 1
                }
            }
        }
        # 存储各个玩家各自的成就进度  eg. “玩家ID” : {"N1" : 4 , "N2" : 5}
        self.mPlayerProgress = {}
        # 存储各个玩家各个节点的额外信息  eg. “玩家ID” : {"N1" : {} , "N2" : {}}
        self.mPlayerExtra = {}
        # 储存处理后的extra数据
        self.mLocalData = {}
        # 存储根据mNodeDetail整理出来的Map，开发者可模仿该编写模式提高监测效率
        self.mCheckMap = {}
        self.GenerateGoalMap()
        logger.info("整理出来的Map{}".format(self.mCheckMap))
        # 记录玩家的Uid
        self.mUid = {}
        self.ListenEvent()

    # 监听事件
    def ListenEvent(self):
        # self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "LoadServerAddonScriptsAfter", self, self.GetServerProgress)
        self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "AddServerPlayerEvent", self, self.OnAddServerPlayerEvent)
        self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "DelServerPlayerEvent", self, self.OnDelServerPlayerEvent)
        self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "MobDieEvent", self,self.KillCheck)

    def OnAddServerPlayerEvent(self, args):
        logger.info("监测到玩家加入")
        LevelId = serverApi.GetLevelId()
        playerId = args["id"]
        HttpComp = compFactory.CreateHttp(LevelId)
        self.mUid[playerId] = HttpComp.GetPlayerUid(playerId)

        def callback(data):
            if data:
                logger.info("这个data为{}".format(data))
                if data["code"] == 0 or data["code"] == 5:
                    if not self.mPlayerProgress.has_key(playerId):
                        self.mPlayerProgress[playerId] = {}
                    if not self.mPlayerExtra.has_key(playerId):
                        self.mPlayerExtra[playerId] = {}
                    for node in self.mNodeList:
                        self.mPlayerProgress[playerId][node] = 0
                        extraString = ""
                        for e in self.mNodeDetail[node]["targetEntity"]:
                            extraString = extraString + e + "+0|"
                        extraString = extraString[0:len(extraString) - 1]
                        self.mPlayerExtra[playerId][node] = extraString
                        logger.info("该node的extra为%s", extraString)
                        self.TransferLocalFromExtra(playerId)
                    if data["entity"]:
                        for Node in data["entity"]:
                            self.mPlayerProgress[playerId][Node["achievement_id"]] = Node["progress"]
                            self.mPlayerExtra[playerId][Node["achievement_id"]] = Node["extra"]
                    self.TransferLocalFromExtra(playerId)
                    logger.info("当前玩家的存储数据为{0}  还有 {1}".format(self.mPlayerProgress[playerId], self.mPlayerExtra[playerId]))

        if not DEBUG:
            AchievementComp = compFactory.CreateAchievement(LevelId)
            AchievementComp.LobbyGetAchievementStorage(callback,playerId)
        else:
            # 本地构造数据模拟数据获取
            callback({
                "code" : 0,
                "entity" : [
                    {
                        "achievement_id" : "N1",
                        "extra" : "minecraft:cow+4|minecraft:sheep+3",
                        "progress" : 7
                    },
                    {
                        "achievement_id": "N2",
                        "extra": "minecraft:cow+1|minecraft:cat+1",
                        "progress": 2
                    }
                ]
            })

    # 处理玩家的Extra数据并存在我们的mLocalData中
    def TransferLocalFromExtra(self,playerId):
        if not self.mLocalData.has_key(playerId):
            self.mLocalData[playerId] = {}
        for node in self.mPlayerExtra[playerId]:
            spiltedData = self.mPlayerExtra[playerId][node].split("|")
            for e in spiltedData:
                goalEntity = e.split("+")[0]
                goalNumber = e.split("+")[1]
                if not self.mLocalData[playerId].has_key(node):
                    self.mLocalData[playerId][node] = {}
                self.mLocalData[playerId][node][goalEntity] = int(goalNumber)

    # 将Local中的数据转为Extra的string类型
    def TransferExtraFromLocal(self,playerId):
        for node in self.mLocalData[playerId]:
            extraString = ""
            for e in self.mLocalData[playerId][node]:
                extraString = extraString + e + "+" + str(self.mLocalData[playerId][node][e]) + "|"
            extraString = extraString[0:len(extraString)-1]
            self.mPlayerExtra[playerId][node] = extraString
            logger.info("该node的extra为%s",extraString)

    # 为需要监听的目标生物建立一个map提高监听到生物死亡的时候的遍历速度，eg {"minecraft:cow" : [N1,N2] , "minecraft:cat" : N2}
    def GenerateGoalMap(self):
        for node in self.mNodeDetail:
            for target in self.mNodeDetail[node]["targetEntity"]:
                if not self.mCheckMap.has_key(target):
                    self.mCheckMap[target] = []
                self.mCheckMap[target].append(node)

    def KillCheck(self,args):
        if not self.mPlayerProgress.has_key(args["attacker"]):
            return
        comp = serverApi.GetEngineCompFactory().CreateEngineType(args["id"])
        entityType = comp.GetEngineTypeStr()
        logger.info("被击杀的生物为%s",entityType)
        for goalEntity in self.mCheckMap:
            if goalEntity == entityType:
                for node in self.mCheckMap[goalEntity]:
                    logger.info("监测到该节点为目标节点%s",node)
                    self.AddProgress(args["attacker"], node, entityType)
                break

    def AddProgress(self, playerId, node, entity):
        logger.info("当前的进度为 %d 和 %d",self.mPlayerProgress[playerId][node],self.mLocalData[playerId][node][entity])
        # 检查节点进度在添加前是否已经达成，达成则返回False
        if self.mPlayerProgress[playerId][node] >= self.mNodeDetail[node]["goalNumber"]\
            or self.mLocalData[playerId][node][entity] >= self.mNodeDetail[node]["targetEntity"][entity]:
            return False

        def getter():
            return self.mPlayerExtra[playerId][node]

        self.mPlayerProgress[playerId][node] += 1
        self.mLocalData[playerId][node][entity] += 1
        self.TransferExtraFromLocal(playerId)

        def callback(data):
            if data:
                if data["code"] == 0:
                    logger.info("%s 节点进度增加1", node)
                    if self.mPlayerProgress[playerId][node] >= self.mNodeDetail[node]["goalNumber"]:
                        comp = compFactory.CreateMsg(playerId)
                        logger.info("这个节点完成了%s", node)
                        comp.NotifyOneMessage(playerId, node + "： 该成就已经完成！")
                elif data["code"] == 5:# 监测到冲突
                    self.mPlayerProgress[playerId][node] = data["entity"]["progress"]  # 更新本地存储的进度
                    self.mPlayerExtra[playerId][node] = data["entity"]["extra"]
                    self.TransferLocalFromExtra(playerId)
                    # 返回一个信号量用于返回更新后的extra数据是否还满足添加进度的条件，满足返回True，否则返回False，只有当code = 5，即起冲突需要放回值
                    if self.mPlayerProgress[playerId][node] >= self.mNodeDetail[node]["goalNumber"]\
                        or self.mLocalData[playerId][node][entity] >= self.mNodeDetail[node]["targetEntity"][entity]:
                        return False
                    else:
                        # 起冲突了，会把上面添加进度的信息覆盖，判断允许添加进度，需要重新添加本地进度，LobbySetAchievementStorage会通过getter函数获取到最新的extra进行存储
                        self.mPlayerProgress[playerId][node] += 1
                        self.mLocalData[playerId][node][entity] += 1
                        self.TransferExtraFromLocal(playerId)
                        return True
                else:
                    # 请求失败
                    comp = compFactory.CreateMsg(playerId)
                    comp.NotifyOneMessage(playerId, "添加进度失败！")
                    self.mPlayerProgress[playerId][node] -= 1
                    self.mLocalData[playerId][node][entity] -= 1
                    self.TransferExtraFromLocal(playerId)

        LevelId = serverApi.GetLevelId()
        if not DEBUG:
            AchievementComp = compFactory.CreateAchievement(LevelId)
            AchievementComp.LobbySetAchievementStorage(callback, playerId, node, 1, getter)
        else:
            callback({
                "code" : 0,
                "entity" : {
                    "extra" : "",
                    "progress" : 2
                }
            })

    def OnDelServerPlayerEvent(self,args):
        self.mUid.pop(args["id"], None)

    def Destroy(self):
        print "===== lobbyAchievementServerSystem Destroy ====="
        self.UnListenEvent()

    def UnListenEvent(self):
        self.UnListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "AddServerPlayerEvent", self, self.OnAddServerPlayerEvent)
        self.UnListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "DelServerPlayerEvent", self, self.OnDelServerPlayerEvent)
        self.UnListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "MobDieEvent", self, self.KillCheck)
