# -*- coding: utf-8 -*-
import mod.client.extraClientApi as clientApi
from common import eventUtil
from common.minecraftEnum import GamepadKeyType
ScreenNode = clientApi.GetScreenNodeCls()

class GamepadUIScreen(ScreenNode):
	def __init__(self, namespace, name, param):
		ScreenNode.__init__(self, namespace, name, param)

	def Create(self):
		createUIBtnPath = "/panel/button0"
		pushScreenBtnPath = "/panel/button1"
		cloaseBtnPath = "/panel/closeButton"
		createUIBtnControl = self.GetBaseUIControl(createUIBtnPath).asButton()
		pushScreenBtnControl = self.GetBaseUIControl(pushScreenBtnPath).asButton()
		cloaseBtnControl = self.GetBaseUIControl(cloaseBtnPath).asButton()
		createUIBtnControl.AddTouchEventParams()
		createUIBtnControl.SetButtonTouchDownCallback(self._onCreateUIBtnDown)
		pushScreenBtnControl.AddTouchEventParams()
		pushScreenBtnControl.SetButtonTouchDownCallback(self._onPushScreenBtnDown)
		cloaseBtnControl.AddTouchEventParams()
		cloaseBtnControl.SetButtonTouchDownCallback(self._onCloseBtnDown)
		self._listenEvent()
		
	def _listenEvent(self):
		eventUtil.instance.ListenForEventClient(clientApi.GetEngineNamespace(), clientApi.GetEngineSystemName(), 'OnGamepadKeyPressClientEvent', self, self._onGamepadKeyPress, 0, False)

	def _onGamepadKeyPress(self, args):
		if args["key"] == GamepadKeyType.KEY_B and args["isDown"] == "0":
			self._popScreen()

	def _onCreateUIBtnDown(self, args):
		self._popScreen()
		clientApi.CreateUI("GamepadUIMod", "createUI", {"isHud":0})

	def _onPushScreenBtnDown(self, args):
		self._popScreen()
		clientApi.PushScreen("GamepadUIMod", "wheelUI")

	def _onCloseBtnDown(self, args):
		self._popScreen()

	def _popScreen(self):
		clientApi.PopScreen()

	def Destroy(self):
		eventUtil.instance.UnListenForEventClient(clientApi.GetEngineNamespace(), clientApi.GetEngineSystemName(), 'OnGamepadKeyPressClientEvent', self, self._onGamepadKeyPress, 0, False)
