# -*- coding: utf-8 -*-
import mod.client.extraClientApi as clientApi
ScreenNode = clientApi.GetScreenNodeCls()

class CreateUIScreen(ScreenNode):
	def __init__(self, namespace, name, param):
		ScreenNode.__init__(self, namespace, name, param)
		self.mPromptBoxPath = None
		self.mPromptBoxControl = None

	def Create(self):
		hoverBtnPath = "/panel/hoverBtn"
		cloaseBtnPath = "/panel/closeBtn"
		hoverBtnControl = self.GetBaseUIControl(hoverBtnPath).asButton()
		cloaseBtnControl = self.GetBaseUIControl(cloaseBtnPath).asButton()
		hoverBtnControl.AddHoverEventParams()
		hoverBtnControl.SetButtonHoverInCallback(self._onHoverInBtn)
		hoverBtnControl.SetButtonHoverOutCallback(self._onHoverOutBtn)
		cloaseBtnControl.AddTouchEventParams()
		cloaseBtnControl.SetButtonTouchDownCallback(self._onCloseBtnDown)
		self.mPromptBoxPath = "/panel/hoverBtn/promptBox" 
		self.mPromptBoxControl = self.GetBaseUIControl(self.mPromptBoxPath)
		self.mPromptBoxControl.SetVisible(False)
		
	def _onHoverInBtn(self, args):
		self.mPromptBoxControl.SetVisible(True)

	def _onHoverOutBtn(self, args):
		self.mPromptBoxControl.SetVisible(False)

	def _onCloseBtnDown(self, args):
		self.SetIsHud(1)
		self.SetRemove()

