# -*- coding: utf-8 -*-
#

import mod.client.extraClientApi as clientApi
import math

compFactory = clientApi.GetEngineCompFactory()


class ScoutToolClient(clientApi.GetClientSystemCls()):
	def __init__(self, namespace, name):
		super(ScoutToolClient, self).__init__(namespace, name)
		self.mTargetRot = None
		self.mRotComp = None
		self.mRot = None
		self.mPlayerId = clientApi.GetLocalPlayerId()
		# 设置各个轴的探测距离,X轴为 8*2,Y轴为 2*2,Z轴为 8*2
		self.mScoutScope = (8, 2, 8)
		self.t = 0
		self.Init()
		self.ListenEvent()

	def Init(self):
		print "============= ScoutToolClient init ============"

	def ListenEvent(self):
		self.ListenForEvent(clientApi.GetEngineNamespace(), clientApi.GetEngineSystemName(), 'OnGamepadTriggerClientEvent', self,  self._onItemTryUse)

	def _onItemTryUse(self, args):
		if args["magnitude"] > 0:
			comp = clientApi.GetEngineCompFactory().CreateItem(self.mPlayerId)
			item = comp.GetPlayerItem(clientApi.GetMinecraftEnum().ItemPosType.CARRIED, 0)
			itemName = item["newItemName"]
			if itemName == "gamepadmod:scout_tool" and not self.mTargetRot:
				self._scoutTarget()
				comp = clientApi.GetEngineCompFactory().CreateCamera(clientApi.GetLevelId())
				cmareRot = comp.GetCameraRotation()
				self.mRot = (cmareRot[0],cmareRot[1] + 180)
		else:
			self.mTargetRot = None
			self.t = 0

	def Update(self):
		if self.mTargetRot and self.t < 1.0:
			self.t += 0.02
			targetQ = self.euler_to_quaternion(self.mTargetRot[0], self.mTargetRot[1])
			cameraQ = self.euler_to_quaternion(-self.mRot[0], self.mRot[1])
			resultQ = self.quaternion_slerp(cameraQ, targetQ, self.t)
			resultRot = self.quaternion_to_euler(resultQ)
			comp = clientApi.GetEngineCompFactory().CreateCamera(clientApi.GetLevelId())
			comp.SetCameraRotation((resultRot[0], resultRot[1] + 180, 0))

	def _scoutTarget(self):
		playerPosComp = clientApi.GetEngineCompFactory().CreatePos(self.mPlayerId)
		playerPos = playerPosComp.GetPos()
		comp = clientApi.GetEngineCompFactory().CreateGame(clientApi.GetLevelId())
		# 获取探测区域的实体ID list
		entities = comp.GetEntityInArea(self.mPlayerId, (playerPos[0]-self.mScoutScope[0], playerPos[1] -self.mScoutScope[1], playerPos[2]-self.mScoutScope[2]), \
								  (playerPos[0]+self.mScoutScope[0], playerPos[1]+self.mScoutScope[1], playerPos[2]+self.mScoutScope[2]), True)
		# 如果找到实体,则计算转向该实体的旋转角度
		if len(entities):
			targetPosComp = clientApi.GetEngineCompFactory().CreatePos(entities[0])
			targetFootPos = targetPosComp.GetFootPos()
			comp = clientApi.GetEngineCompFactory().CreateCamera(clientApi.GetLevelId())
			self.mTargetRot = self._calculateRotation(comp.GetPosition(), targetFootPos)
	
	def _calculateRotation(self, cameraPos, targetPos):
		# 计算B坐标相对于A坐标的向量差
		targetPos_cameraPos = (targetPos[0] - cameraPos[0], targetPos[1] - cameraPos[1], targetPos[2] - cameraPos[2])
		# 计算方位角（绕竖轴的旋转角度）
		azimuth = math.atan2(targetPos_cameraPos[0], targetPos_cameraPos[2])
		# 将B坐标绕竖轴逆时针旋转方位角azimuth
		targetPos_azimuth = (targetPos_cameraPos[0], targetPos_cameraPos[1], targetPos_cameraPos[2] * math.cos(azimuth) - targetPos_cameraPos[0] * math.sin(azimuth))
		# 计算俯仰角（绕横轴的旋转角度）
		elevation = math.atan2(targetPos_azimuth[1], math.sqrt(targetPos_azimuth[0]**2 + targetPos_azimuth[2]**2))
		elevation_degrees = math.degrees(elevation)
		azimuth_degrees = math.degrees(azimuth)
		return (elevation_degrees, -azimuth_degrees)

	# 将欧拉角转成四元数
	def euler_to_quaternion(self, pitch, yaw, roll = 0):
		roll = math.radians(roll)
		pitch = math.radians(pitch)
		yaw = math.radians(yaw)

		cy = math.cos(yaw * 0.5)
		sy = math.sin(yaw * 0.5)
		cp = math.cos(pitch * 0.5)
		sp = math.sin(pitch * 0.5)
		cr = math.cos(roll * 0.5)
		sr = math.sin(roll * 0.5)

		qw = cy * cp * cr + sy * sp * sr
		qx = cy * cp * sr - sy * sp * cr
		qy = sy * cp * sr + cy * sp * cr
		qz = sy * cp * cr - cy * sp * sr

		return [qw, qx, qy, qz]

	# 将四元数专场欧拉角
	def quaternion_to_euler(self, quat):
		yaw = math.atan2(2*(quat[1]*quat[2] + quat[0]*quat[3]), quat[0]**2 + quat[1]**2 - quat[2]**2 - quat[3]**2)
		pitch = math.asin(-2*(quat[0]*quat[2] - quat[1]*quat[3]))
		roll = math.atan2(2*(quat[0]*quat[1] + quat[2]*quat[3]), quat[0]**2 - quat[1]**2 - quat[2]**2 + quat[3]**2)
		roll = math.degrees(roll)
		pitch = math.degrees(pitch)
		yaw = math.degrees(yaw)
		return (pitch, yaw)
	
	# 四元数进行球面线性插值计算
	def quaternion_slerp(self, q1, q2, t):
		dot_product = q1[0]*q2[0] + q1[1]*q2[1] + q1[2]*q2[2] + q1[3]*q2[3]
		
		if dot_product < 0.0:
			q2 = [-q2[i] for i in range(4)]
			dot_product = -dot_product
		
		if dot_product > 0.9995:
			result = [q1[i] + t*(q2[i]-q1[i]) for i in range(4)]
		else:
			theta_0 = math.acos(dot_product)
			theta = theta_0 * t
			
			sin_theta_0 = math.sin(theta_0)
			sin_theta = math.sin(theta)
			
			s0 = math.cos(theta) - dot_product * sin_theta / sin_theta_0
			s1 = sin_theta / sin_theta_0

			result = [q1[i]*s0 + q2[i]*s1 for i in range(4)]
		return result