# -*- coding: utf-8 -*-
#
import random

import mod.server.extraServerApi as serverApi
import json

minecraftEnum = serverApi.GetMinecraftEnum()
compFactory = serverApi.GetEngineCompFactory()

class GamepadModServer(serverApi.GetServerSystemCls()):
	def __init__(self, namespace, name):
		super(GamepadModServer, self).__init__(namespace, name)
		self.ListenEvent()

	def ListenEvent(self):
		self.ListenForEvent(serverApi.GetEngineNamespace(), serverApi.GetEngineSystemName(), "AddServerPlayerEvent", self, self.OnAddPlayer)
		self.ListenForEvent("GamepadMod", "GamepadModClient", "CreateItemEvent", self, self.OnCreateItemEvent)

	def OnAddPlayer(self, args):
		playerId = args["id"]
		itemDict = {
			'itemName': 'gamepadmod:guidebook',
			'count': 1,
			'auxValue': 0,
			'customTips': '扣动左扳机查看说明',
		}
		comp = serverApi.GetEngineCompFactory().CreateItem(playerId)
		comp.SpawnItemToPlayerInv(itemDict, playerId, 0)
		itemDict['itemName'] = 'gamepadmod:scout_tool'
		itemDict['customTips'] = '扣左扳机可锁定到周围生物'
		comp.SpawnItemToPlayerInv(itemDict, playerId, 1)
	
	# 监听CreateItemEvent的回调函数
	def OnCreateItemEvent(self, args):
		print("OnCreateItemEvent")
		# 生成掉落物品
		playerId = args["playerId"]
		item = args["item"]
		# 获取组件工厂，用来创建组件
		compFactory = serverApi.GetEngineCompFactory()
		comp = compFactory.CreateItem(playerId)
		# 调用SpawnItemToPlayerInv接口生成物品到玩家背包，参数参考《MODSDK文档》
		comp.SpawnItemToPlayerInv(item, playerId)

