# -*- coding: utf-8 -*-
#

import mod.client.extraClientApi as clientApi

compFactory = clientApi.GetEngineCompFactory()


class GamepadModClient(clientApi.GetClientSystemCls()):
	def __init__(self, namespace, name):
		super(GamepadModClient, self).__init__(namespace, name)
		self.Init()
		self.ListenEvent()

	def Init(self):
		print "========= GamepadModClient init"

	def ListenEvent(self):
		self.ListenForEvent(clientApi.GetEngineNamespace(), clientApi.GetEngineSystemName(), "UiInitFinished", self, self._onUIInitFinished)
		self.ListenForEvent(clientApi.GetEngineNamespace(), clientApi.GetEngineSystemName(), 'ClientItemTryUseEvent', self,  self._onItemTryUse)

	def _onUIInitFinished(self,args):
		clientApi.RegisterUI("GamepadUIMod", "gamepadUI", "script.uiScript.gamepadUIScreen.GamepadUIScreen", "gamepadUI.main")
		clientApi.RegisterUI("GamepadUIMod", "createUI", "script.uiScript.createUIScreen.CreateUIScreen", "createUI.main")
		clientApi.RegisterUI("GamepadUIMod", "wheelUI", "script.uiScript.wheelUIScreen.WheelUIScreen", "wheelUI.main")

	def _onItemTryUse(self, args):
		itemName = args["itemDict"]["newItemName"]
		if itemName == "gamepadmod:guidebook":
			clientApi.PushScreen("GamepadUIMod", "gamepadUI")

	def OnScriptTickClient(self):
		pass

	# 向服务端请求生成物品
	def CreateItem(self, item):
		print("CreateItem")
		self.NotifyToServer("CreateItemEvent", {"item": item, "playerId": clientApi.GetLocalPlayerId()})
