# -*- coding: utf-8 -*-

import mod.client.extraClientApi as clientApi
ClientSystem = clientApi.GetClientSystemCls()


class ParticleClientSystem(ClientSystem):
    def __init__(self, namespace, systemName):
        ClientSystem.__init__(self, namespace, systemName)
        self.ListenForEvent(clientApi.GetEngineNamespace(), clientApi.GetEngineSystemName(), "OnClientPlayerStartMove", self, self._OnStartMove)
        self.ListenForEvent(clientApi.GetEngineNamespace(), clientApi.GetEngineSystemName(), "OnClientPlayerStopMove", self, self._OnStopMove)

        self.particleComp = clientApi.GetEngineCompFactory().CreateParticleSystem(None)
        self.localPlayerId = clientApi.GetLocalPlayerId()
        self.localParticleId = -1
        self.localParticleIdCustom = -1
        self.particleComp.Stop(self.localParticleId)
        self.particleComp.Stop(self.localParticleIdCustom)

    def _OnStartMove(self):
        if not self.particleComp.Exist(self.localParticleId):
            self.localParticleId = self.particleComp.CreateBindEntity("netease:model", self.localPlayerId, "head", (0, 0, 0), (0, 0, 0))

        if not self.particleComp.Exist(self.localParticleIdCustom):
            self.localParticleIdCustom = self.particleComp.CreateBindEntity("netease:model_with_custom_shader", self.localPlayerId, "head", (2, 0, 2), (0, 0, 0))

        self.particleComp.Replay(self.localParticleId)
        self.particleComp.Replay(self.localParticleIdCustom)

    def _OnStopMove(self):
        if self.particleComp.Exist(self.localParticleId):
            self.particleComp.Stop(self.localParticleId)

        if self.particleComp.Exist(self.localParticleIdCustom):
            self.particleComp.Stop(self.localParticleIdCustom)

    def Destroy(self):
        pass
