# -*- coding: utf-8 -*-

from common.mod import Mod
import client.extraClientApi as clientApi
import server.extraServerApi as serverApi
from DataBindingScripts.modCommon import modConfig

@Mod.Binding(name = modConfig.ModName, version = modConfig.ModVersion)
class DataBindingMod(object):
	@Mod.InitServer()
	def DataBindingServerInit(self):
		serverApi.RegisterSystem(modConfig.ModName, modConfig.ServerSystemName, modConfig.ServerSystemClsPath)

	@Mod.DestroyServer()
	def DataBindingServerDestroy(self):
		pass

	@Mod.InitClient()
	def DataBindingClientInit(self):
		clientApi.RegisterSystem(modConfig.ModName, modConfig.ClientSystemName, modConfig.ClientSystemClsPath)

	@Mod.DestroyClient()
	def DataBindingClientDestroy(self):
		pass

