# -*- coding: utf-8 -*-

import mod.client.extraClientApi as clientApi
from mod_log import logger
from functools import wraps
from DataBindingScripts.modCommon import dataBindingCfg

view_binder = clientApi.GetViewBinderCls()
screen_node = clientApi.GetScreenNodeCls()

def touch_filter(touchType):
    def touchFilter(func):
        @wraps(func)
        def decorated(*args, **kwargs):
            touchEventEnum = clientApi.GetMinecraftEnum().TouchEvent
            touchEvent = args[1]["TouchEvent"]
            if touchType == "up":
                if touchEvent == touchEventEnum.TouchUp:
                    value = func(*args, **kwargs)
                    return value
            if touchType == "down":
                if touchEvent == touchEventEnum.TouchDown:
                    value = func(*args, **kwargs)
                    return value
            if touchType == "cancel":
                if touchEvent == touchEventEnum.TouchCancel:
                    value = func(*args, **kwargs)
                    return value
            if touchType == "move":
                if touchEvent == touchEventEnum.TouchMove:
                    value = func(*args, **kwargs)
                    return value
        return decorated
    return touchFilter


class GuideBookUI(screen_node):
    def __init__(self, namespace, name, param):
        super(GuideBookUI, self).__init__(namespace, name, param)
        logger.info("========GuideBook UI init========")
        self.mCloseBtn = "/guideBookPanel/closeBtn"
        # 怪物图鉴分页相关
        self.mMonsterPanel = "/guideBookPanel/guidePanelWrap/guideHeaderContentPanelWrap/monsterHeaderContentPanel"
        self.mMonsterData = {
            0: [],
            1: [],
            2: [],
            3: []
        }
        self.mCurTypeTab = 0
        self.mCurMonsterIndex = 0
        self.mMonsterInfoWrap = self.mMonsterPanel + "/monsterGuideContentRight/monsterGuideDetailWrap"
        self.mMonsterIcon = self.mMonsterInfoWrap + "/monsterGuideDetailPanel/image"
        self.mMonsterName = self.mMonsterInfoWrap + "/monsterGuideDetailPanel/monsterInfoPanel/monsterNamePanel/textWrap/textLabel"
        self.mMonsterHealth = self.mMonsterInfoWrap + "/monsterGuideDetailPanel/monsterInfoPanel/healthPanel/health"
        self.mMonsterAttack = self.mMonsterInfoWrap + "/monsterGuideDetailPanel/monsterInfoPanel/attackPanel/attack"
        self.mMonsterDefense = self.mMonsterInfoWrap + "/monsterGuideDetailPanel/monsterInfoPanel/defensePanel/defense"
        self.mMonsterDescScrollView = self.mMonsterInfoWrap + "/monsterDescScrollingPanel"
        # 万物图鉴分页相关
        self.mItemPanel = "/guideBookPanel/guidePanelWrap/guideHeaderContentPanelWrap/itemHeaderContentPanel"
        self.mItemData = {
            0: [],
            1: [],
            2: [],
            3: []
        }
        self.mCurItemTab = 0
        self.mCurItemIndex = 0
        self.mItemInfoWrap = self.mItemPanel + "/itemGuideContentRight/itemGuideDetailWrap"
        self.mItemIcon = self.mItemInfoWrap + "/itemGuideDetailLeft/image"
        self.mItemName = self.mItemInfoWrap + "/itemGuideDetailLeft/textWrap/textLabel"
        self.mItemDescScrollView = self.mItemInfoWrap + "/itemDescScrollingPanel"
        self.init_data()

        self.mDefaultToggle = self.mItemPanel + "/itemGuideContentLeft/scroll_touch/scroll_view/panel/background_and_viewport/scrolling_view_port/scrolling_content/itemToggleBtn1"

    def init_data(self):
        # 根据配表初始化数据内容
        for key, monsterList in dataBindingCfg.MONSTERDATA.items():
            for monsterDict in monsterList:
                monsterDict["name"] = monsterDict["name"]
                monsterDict["health"] = monsterDict["health"]
                monsterDict["attack"] = monsterDict["attack"]
                monsterDict["defense"] = monsterDict["defense"]
                self.mMonsterData[key].append(monsterDict)

        for key, value in dataBindingCfg.ITEMDATA.items():
            for itemDict in value:
                self.mItemData[key].append(itemDict)

    # Create函数是继承自ScreenNode，会在UI创建完成后被调用
    def Create(self):
        self.mItemDesc = self.get_real_scroll_view(self.mItemDescScrollView) + "/itemGuideDetailDesc"
        self.mMonsterDesc = self.get_real_scroll_view(self.mMonsterDescScrollView) + "/monsterGuideDetailDesc"
        self.AddTouchEventHandler(self.mCloseBtn, self.on_close_click)
        self.OnMonsterToggleChecked({ "index": self.mCurMonsterIndex })
        # 如果三级分页中无内容将禁用对应的二级tab
        for type, monsterList in self.mMonsterData.items():
            self.SetTouchEnable(self.mMonsterPanel + "/monsterToggleGroup/toggle{}".format(type), len(monsterList) != 0)

        for itemTab, itemList in self.mItemData.items():
            self.SetTouchEnable(self.mItemPanel + "/itemTabToggleGroup/toggle{}".format(itemTab), len(itemList) != 0)

    # 继承自ScreenNode的方法，会被引擎自动调用，1秒钟30帧
    def Update(self):
        pass

    @touch_filter("up")
    def on_close_click(self, args):
        clientApi.PopScreen()

    # 单选分页示例
    @view_binder.binding(view_binder.BF_ToggleChanged, "#guideBookTab")
    def OnGuideBookToggleChecked(self, args):
        toggleIndex = args["index"]
        MonsterControl = self.GetBaseUIControl(self.mMonsterPanel)
        ItemUIControl = self.GetBaseUIControl(self.mItemPanel)
        if toggleIndex == 0:
            MonsterControl.SetVisible(True)
            ItemUIControl.SetVisible(False)
            self.OnMonsterToggleChecked({ "index": self.mCurMonsterIndex })
        else:
            MonsterControl.SetVisible(False)
            ItemUIControl.SetVisible(True)
            self.OnItemToggleChecked({ "index": self.mCurItemIndex })

    # 怪物图鉴相关绑定
    @view_binder.binding(view_binder.BF_ToggleChanged, "#typeTab")
    def OnTypeTabChecked(self, args):
        # 二级tab切换时触发，将三级分页默认切换至第一个tab详情页，更新三级分页列表
        self.mCurTypeTab = args["index"]
        self.OnMonsterToggleChecked({ "index": self.mCurMonsterIndex })

    @view_binder.binding(view_binder.BF_ToggleChanged, "#monsterToggleGroup")
    def OnMonsterToggleChecked(self, args):
        # 三级tab切换时触发
        toggleIndex = args["index"]
        if toggleIndex >= len(self.mMonsterData[self.mCurTypeTab]):
            toggleIndex = 0
        self.mCurMonsterIndex = toggleIndex
        # 根据当前index更新对应分页内容
        monsterDict = self.mMonsterData[self.mCurTypeTab][toggleIndex]
        buttonUIControl = self.GetBaseUIControl(self.mMonsterIcon).asImage()
        buttonUIControl.SetSprite(monsterDict["icon"])
        labelUIControl = self.GetBaseUIControl(self.mMonsterName).asLabel()
        labelUIControl.SetText(monsterDict["name"])
        labelUIControl = self.GetBaseUIControl(self.mMonsterHealth).asLabel()
        labelUIControl.SetText("生命: {}".format(monsterDict["health"]))
        labelUIControl = self.GetBaseUIControl(self.mMonsterAttack).asLabel()
        labelUIControl.SetText("攻击: {}".format(monsterDict["attack"]))
        labelUIControl = self.GetBaseUIControl(self.mMonsterDefense).asLabel()
        labelUIControl.SetText("防御: {}".format(monsterDict["defense"]))
        labelUIControl = self.GetBaseUIControl(self.mMonsterDesc).asLabel()
        labelUIControl.SetText(monsterDict["desc"])
        MonsterInfoUIControl = self.GetBaseUIControl(self.mMonsterInfoWrap)
        MonsterInfoUIControl.SetVisible(True)

    @view_binder.binding(view_binder.BF_BindInt, "#monsterToggleGrid.item_count")
    def OnMonsterGridResize(self):
        # 三级tab长度绑定，在二级分页切换时更新self.mCurTypeTab会使该返回值发生变化
        return len(self.mMonsterData[self.mCurTypeTab])

    @view_binder.binding_collection(view_binder.BF_BindString, "monsterToggles", "#label_name.text")
    def OnRefreshMonsterLabel(self, index):
        # 当三级tab列表长度发生变化时触发，会更新三级tab列表的文本
        return self.mMonsterData[self.mCurTypeTab][index]["name"] if len(self.mMonsterData[self.mCurTypeTab]) > index else ""

    # 万物图鉴相关绑定
    @view_binder.binding(view_binder.BF_ToggleChanged, "#itemTab")
    def OnItemTabChecked(self, args):
        self.mCurItemTab = args["index"]
        self.mCurItemIndex = 0
        self.SetToggleStateNew(self.mDefaultToggle, True)
        self.OnItemToggleChecked({ "index": self.mCurItemIndex })

    @view_binder.binding(view_binder.BF_ToggleChanged, "#itemToggleGroup")
    def OnItemToggleChecked(self, args):
        # 当点击#itemToggleGroup中的toggle时会调用该函数，传入的args中有对应点击的index，在该回调函数中完成分页内容的设置
        toggleIndex = args["index"]
        if toggleIndex >= len(self.mItemData[self.mCurItemTab]):
            toggleIndex = 0
        self.mCurItemIndex = toggleIndex
        itemDict = self.mItemData[self.mCurItemTab][toggleIndex]
        buttonUIControl = self.GetBaseUIControl(self.mItemIcon).asImage()
        buttonUIControl.SetSprite(itemDict["icon"])
        labelUIControl = self.GetBaseUIControl(self.mItemName).asLabel()
        labelUIControl.SetText(itemDict["name"])
        labelUIControl = self.GetBaseUIControl(self.mItemDesc).asLabel()
        labelUIControl.SetText(itemDict["desc"])
        ItemInfoUIControl = self.GetBaseUIControl(self.mItemInfoWrap)
        ItemInfoUIControl.SetVisible(True)

    @view_binder.binding(view_binder.BF_BindInt, "#itemToggleGrid.item_count")
    def OnItemGridResize(self):
        # 将stack_grid的size和对应的data数量绑定起来，实现数据驱动，有多少内容显示多少
        return len(self.mItemData[self.mCurItemTab])

    @view_binder.binding_collection(view_binder.BF_BindString, "itemToggles", "#label_name.text")
    def OnRefreshItemLabel(self, index):
        # 这里返回的文字会显示在对应index的itemLabel上
        return self.mItemData[self.mCurItemTab][index]["name"] if len(self.mItemData[self.mCurItemTab]) > index else ""

    # ----------------------------------------------------------
    def get_real_scroll_view(self, componentPath):
        path = componentPath + "/scroll_touch/scroll_view"
        childList = self.GetChildrenName(path)
        if childList and len(self.GetChildrenName(path)) > 0:
            return path + "/panel/background_and_viewport/scrolling_view_port/scrolling_content"
        path = componentPath + "/scroll_mouse/scroll_view"
        childList = self.GetChildrenName(path)
        if childList and len(self.GetChildrenName(path)) > 0:
            return path + "/stack_panel/background_and_viewport/scrolling_view_port/scrolling_content"
        return ""
