# -*- coding: utf-8 -*-

import mod.client.extraClientApi as clientApi
from DataBindingScripts.modCommon import modConfig
from mod_log import logger
from functools import wraps


view_binder = clientApi.GetViewBinderCls()
screen_node = clientApi.GetScreenNodeCls()


def touch_filter(touchType):
	def touchFilter(func):
		@wraps(func)
		def decorated(*args, **kwargs):
			touchEventEnum = clientApi.GetMinecraftEnum().TouchEvent
			touchEvent = args[1]["TouchEvent"]
			if touchType == "up":
				if touchEvent == touchEventEnum.TouchUp:
					value = func(*args, **kwargs)
					return value
			if touchType == "down":
				if touchEvent == touchEventEnum.TouchDown:
					value = func(*args, **kwargs)
					return value
			if touchType == "cancel":
				if touchEvent == touchEventEnum.TouchCancel:
					value = func(*args, **kwargs)
					return value
			if touchType == "move":
				if touchEvent == touchEventEnum.TouchMove:
					value = func(*args, **kwargs)
					return value
		return decorated
	return touchFilter


class DemoHudUI(screen_node):
    def __init__(self, namespace, name, param):
        super(DemoHudUI, self).__init__(namespace, name, param)
        logger.info("========demoHud UI init========")
        # 主界面hud按钮
        self.mGuideBookButton = "/guideBookBtn"

    # Create函数是继承自ScreenNode，会在UI创建完成后被调用
    def Create(self):
        self.AddTouchEventHandler(self.mGuideBookButton, self.on_guide_book_click)

    # 继承自ScreenNode的方法，会被引擎自动调用，1秒钟30帧
    def Update(self):
        pass

    @touch_filter("up")
    def on_guide_book_click(self, args):
        """
        打开图鉴按钮
        """
        clientApi.PushScreen(modConfig.ModName, "guideBookUI")
