# -*- coding: utf-8 -*-

import client.extraClientApi as clientApi
ClientSystem = clientApi.GetClientSystemCls()
from DataBindingScripts.modCommon import modConfig

class DataBindingClientSystem(ClientSystem):
	def __init__(self, namespace, systemName):
		ClientSystem.__init__(self, namespace, systemName)
		self.ListenEvent()

	def ListenEvent(self):
		namespace = clientApi.GetEngineNamespace()
		system_name = clientApi.GetEngineSystemName()
		self.ListenForEvent(namespace, system_name, "UiInitFinished", self, self.init_all_ui)

	def init_all_ui(self, data):
		clientApi.RegisterUI(modConfig.ModName, "guideBookUI", "DataBindingScripts.modClient.ui.guideBookUI.GuideBookUI", "guideBookUI.main")
		clientApi.RegisterUI(modConfig.ModName, "demoHudUI", "DataBindingScripts.modClient.ui.demoHudUI.DemoHudUI", "demoHudUI.main")
		clientApi.CreateUI(modConfig.ModName, "demoHudUI", {"inputMode": 0})
