# -*- coding: utf-8 -*-

import client.extraClientApi as clientApi
ClientSystem = clientApi.GetClientSystemCls()
from CrackFrameScripts.modCommon import modConfig

compFactory = clientApi.GetEngineCompFactory()
minecraftEnum = clientApi.GetMinecraftEnum()
levelId = clientApi.GetLevelId()


class CrackFrameClientSystem(ClientSystem):
	def __init__(self, namespace, systemName):
		ClientSystem.__init__(self, namespace, systemName)
		self.ListenEvent()
		# 记录时间方便在update中定时执行
		self._time = 0
		# 获取当前玩家id
		self.mPlayerId = clientApi.GetLocalPlayerId()
		# 获取当前玩家维度
		self.mDimension = compFactory.CreateGame(levelId).GetCurrentDimension()
		# 获取记录玩家指向方块破坏纹理渲染进度，当渲染进度为9时归为0
		"""
		数据格式：
		key ——> (blockPos, blockDimension) # 方块位置和维度作为唯一key
		Value ——> CrackFrameStatues # 方块所处破坏纹理阶段作为值 0-9
		"""
		self._blockCrackFrameInfo = {
		}

	def ListenEvent(self):
		namespace = clientApi.GetEngineNamespace()
		system_name = clientApi.GetEngineSystemName()
		self.ListenForEvent(namespace, system_name, "UiInitFinished", self, self.init_all_ui)

	def init_all_ui(self, data):
		# 创建hud UI
		pass
		# clientApi.RegisterUI(modConfig.ModName, "openDebugDrawingGUI", "CrackFrameScripts.modClient.ui.openDebugDrawingGUI.OpenDebugDrawingGUI", "openDebugDrawingGUI.main")
		# clientApi.CreateUI(modConfig.ModName, "openDebugDrawingGUI", {"inputMode": 0})

	def Update(self):
		self._time += 1
		if self._time % 5 == 0:
			pickData = compFactory.CreateCamera(levelId).PickFacing()
			if pickData['type'] == 'Block':
				x, y, z = pickData['x'],pickData['y'],pickData['z']
				blockPos = (x, y, z)
				key = (blockPos, self.mDimension)
				CrackFrameStatues = 0
				if key in self._blockCrackFrameInfo:
					CrackFrameStatues = self._blockCrackFrameInfo[key]
				compFactory.CreateBlockInfo(levelId).SetCrackFrame(self.mDimension, (x, y, z), CrackFrameStatues)
				CrackFrameStatues += 1
				if CrackFrameStatues >= 10:
					CrackFrameStatues = 0
				self._blockCrackFrameInfo[key] = CrackFrameStatues
				# 在(30,66,30)这个位置播放破坏方块的纹理，进度为1
			else:
				return
			# 当有100个已经记录破坏状态的方块时，全部统一清楚。释放内存,防止过于卡顿
			if len(self._blockCrackFrameInfo) >= 100:
				for key in self._blockCrackFrameInfo:
					blockPos, blockDimension = key[0], key[1]
					compFactory.CreateBlockInfo(levelId).DestroyCrackFrame(blockDimension, blockPos)
				self._blockCrackFrameInfo = {}
			self._time = 0