# -*- coding: utf-8 -*-

import server.extraServerApi as serverApi
ServerSystem = serverApi.GetServerSystemCls()
from DemoScripts.modCommon import modConfig

compFactory = serverApi.GetEngineCompFactory()
minecraftEnum = serverApi.GetMinecraftEnum()
levelId = serverApi.GetLevelId()

class DemoServerSystem(ServerSystem):
	def __init__(self, namespace, systemName):
		ServerSystem.__init__(self, namespace, systemName)
		self.ListenEvent()
		self._dropItemDict = {} # dropItemId: (itemDict, entityId)

	def ListenEvent(self):
		namespace = serverApi.GetEngineNamespace()
		system_name = serverApi.GetEngineSystemName()
		self.ListenForEvent(namespace, system_name, "EntityDroppedItemServerEvent", self, self.OnEntityDroppedItemServer) # 监听物品被丢弃事件
		self.ListenForEvent(namespace, system_name, "OnGroundServerEvent", self, self.OnGroundServer) # 监听实体碰撞事件
	
	def OnEntityDroppedItemServer(self, args):
		itemDict, entityId, itemEntityId = args["itemDict"], args["entityId"], args["itemEntityId"]
		if itemDict:
			compFactory.CreateGame(levelId).OpenMobHitBlockDetection(itemEntityId, 0.01) # 打开掉落物的碰撞检测
			self._dropItemDict[itemEntityId] = (itemDict, entityId) # 记录掉落物实体id作为字典的key；value则是物品字典和丢弃者的实体id组成的元组。将数据记录在客户端，方便碰撞时做检测
			
	
	def OnGroundServer(self, args):
		itemId = args["id"]
		if itemId in self._dropItemDict: # 说明扔出的掉落物碰撞了方块（如掉落地面等情况）
			dropItemDict, droperId = self._dropItemDict[itemId][0], self._dropItemDict[itemId][1]
			dropPos = compFactory.CreatePos(itemId).GetPos()
			dropX, dropY, dropZ = dropPos[0], dropPos[1], dropPos[2]
			dimensionId = compFactory.CreateDimension(itemId).GetEntityDimensionId()
			# 获取 10 x 2 x 10范围内的实体id
			entityIdList = compFactory.CreateGame(levelId).GetEntitiesInSquareArea(None, (dropX - 10, dropY - 2, dropZ - 10), (dropX + 10, dropY + 2, dropZ + 10), dimensionId)
			if droperId in entityIdList: # 如果扔出的人也在范围内，则去除他自己（防止我扔出的物品对我造成伤害情况出现）
				entityIdList.remove(droperId)
			if itemId in entityIdList: # 如果扔出的物品也在范围内，则去除他自己（防止物品消失）
				entityIdList.remove(itemId)
			if entityIdList:
				for entityId in entityIdList: # 注意：这里如果生物很多的话就会引起卡顿，开发者可以自行进行分帧处理。以及这里没有做耐久损耗记录，开发者可自行进行扩展
					result = compFactory.CreateGame(levelId).UseItemAttackEntity(dropItemDict, entityId) # 对范围内所有实体造成该物品的伤害
					if result: # 造成伤害成功（注意，如果这个物品没有攻击力，则不会造成伤害也会反馈成功结果。具体请查看UseItemAttackEntity接口备注）
						print "成功对实体造成伤害"
			self._dropItemDict.pop(itemId) # 删除已经造成伤害的掉落物字典信息，避免占用服务端内存！！！
		
	def Update(self):
		for dropItemId in self._dropItemDict.keys():
			alive = compFactory.CreateGame(levelId).IsEntityAlive(dropItemId) # 检测掉落物是否还存在，如不存在则删除其self._dropItemDict字典记录，避免被删除后无法碰撞，导致字典没有删除，增加服务端无用内存占用。
			#这里也可以使用EntityRemoveEvent事件做逻辑，请开发者自行选择，本处使用循环检测
			if not alive:
				self._dropItemDict.pop(dropItemId)

