# -*- coding: utf-8 -*-

import mod.client.extraClientApi as clientApi
from mod_log import logger
from functools import wraps
from DebugDrawingScripts.modCommon import modConfig
# from DebugDrawingScripts.modCommon import DebugDrawingCfg

screen_node = clientApi.GetScreenNodeCls()
compFactory = clientApi.GetEngineCompFactory()
minecraftEnum = clientApi.GetMinecraftEnum()
levelId = clientApi.GetLevelId()

class SetDebugDrawing(screen_node):
	def __init__(self, namespace, name, param):
		super(SetDebugDrawing, self).__init__(namespace, name, param)
		logger.info("========Create UI init========")
		# 获取当前玩家id
		self.mPlayerId = clientApi.GetLocalPlayerId()
		self._addBtnPanel = "/main_panel/add_panel/add_btn_panel"
		self._closeBtnPath = "/main_panel/add_panel/close_btn"
		self._btnDict = {} # 用于存放实例化的按钮object，key为自定义的key（如下面的box），value为按钮对象
		self._btnPath = { # 创建自定义key与按钮路径的映射
			"box": self._addBtnPanel + "/add_box_btn",
			"closeBtn": self._closeBtnPath,
			"line": self._addBtnPanel + "/add_line_btn",
			"circle": self._addBtnPanel + "/add_circle_btn",
			"arrow": self._addBtnPanel + "/add_arrow_btn",
			"text": self._addBtnPanel + "/add_text_btn",
			"sphere": self._addBtnPanel + "/add_sphere_btn",
		}
		self._pushScreen = { # 创建自定义key与pushScreen中参数的映射
			"box": "createBoxDebugDrawing",
		}
		self._btnFunc = {
			"line": self.CreateLine,
			"circle": self.CreateCircle,
			"arrow": self.CreateArrow,
			"text": self.CreateText,
			"sphere": self.CreateSphere,
		}

	def init_data(self):
		# 根据配表初始化数据内容
		pass
		

	# Create函数是继承自ScreenNode，会在UI创建完成后被调用
	def Create(self):
		for key, btnPath in self._btnPath.items():
			self.UICreateBtn(self._btnDict, key, btnPath, None, self.OnBtnPressUp) # 批量创建按钮回调，并将创建后的按钮实例保存在self._btnDict字典中

	def OnBtnPressUp(self, args):
		clickType = args['AddTouchEventParams']['type']
		if clickType == "closeBtn":
			clientApi.PopScreen()
		else:
			if clickType in self._pushScreen and self._pushScreen[clickType]:
				clientApi.PushScreen(modConfig.ModName, self._pushScreen[clickType])
			elif clickType in self._btnFunc and self._btnFunc[clickType]:
				self._btnFunc[clickType]()
				clientApi.PopScreen()
	
	def CreateCircle(self):
		myPos = compFactory.CreatePos(self.mPlayerId).GetPos()
		clientApi.GetEngineCompFactory().CreateDrawing(levelId).AddCircleShape(myPos, 5, (1,0,0))
	
	def CreateArrow(self):
		myPos = compFactory.CreatePos(self.mPlayerId).GetPos()
		clientApi.GetEngineCompFactory().CreateDrawing(levelId).AddArrowShape(myPos, (20,150,20), (1,0,0), 40, 5, 2.5)

	def CreateLine(self):
		myPos = compFactory.CreatePos(self.mPlayerId).GetPos()
		clientApi.GetEngineCompFactory().CreateDrawing(levelId).AddLineShape(myPos, (0,0,0),(1,0,0))

	def CreateSphere(self):
		myPos = compFactory.CreatePos(self.mPlayerId).GetPos()
		clientApi.GetEngineCompFactory().CreateDrawing(levelId).AddSphereShape(myPos, 5, (1,0,0))

	def CreateText(self):
		myPos = compFactory.CreatePos(self.mPlayerId).GetPos()
		clientApi.GetEngineCompFactory().CreateDrawing(levelId).AddTextShape(myPos, "test 测试", (1,0,0))

	# 继承自ScreenNode的方法，会被引擎自动调用，1秒钟30帧
	def Update(self):
		pass
	
	# region 方法
	def UICreateBtn(uiInstance, btnDict, btnKey, path, param=None, upFunc=None, downFunc=None, moveFunc=None):
		if param is None:
			param = {"isSwallow": True, "type": btnKey}
		if type(btnDict) != dict:
			btnDict = {}
		if type(btnKey) != str:
			return
		btnDict.update({btnKey: uiInstance.GetBaseUIControl(path).asButton()})
		btnDict[btnKey].AddTouchEventParams(param)
		if upFunc is not None:
			btnDict[btnKey].SetButtonTouchUpCallback(upFunc)
		if downFunc is not None:
			btnDict[btnKey].SetButtonTouchDownCallback(downFunc)
		if moveFunc is not None:
			btnDict[btnKey].SetButtonTouchMoveCallback(moveFunc)
	# enregion

