# -*- coding: utf-8 -*-

import mod.client.extraClientApi as clientApi
from DebugDrawingScripts.modCommon import modConfig
from mod_log import logger
from functools import wraps


view_binder = clientApi.GetViewBinderCls()
screen_node = clientApi.GetScreenNodeCls()
compFactory = clientApi.GetEngineCompFactory()
minecraftEnum = clientApi.GetMinecraftEnum()
safePath0 = '/variables_button_mappings_and_controls/safezone_screen_matrix/inner_matrix'
safePath = safePath0+'/safezone_screen_panel/root_screen_panel'
levelId = clientApi.GetLevelId()

class OpenDebugDrawingGUI(screen_node):
	def __init__(self, namespace, name, param):
		super(OpenDebugDrawingGUI, self).__init__(namespace, name, param)
		logger.info("========hud UI init========")
		# 主界面hud按钮
		self._hudBtnPath = "/open_button"
		self._hudBtn = None

	# Create函数是继承自ScreenNode，会在UI创建完成后被调用
	def Create(self):
		self._hudBtn =self.GetBaseUIControl(safePath + self._hudBtnPath).asButton()
		self._hudBtn.AddTouchEventParams({"isSwallow": True})
		self._hudBtn.SetButtonTouchUpCallback(self.OnTableBtnTouchUp)
		self.UIinit()

	def UIinit(self):
		pass

	# 继承自ScreenNode的方法，会被引擎自动调用，1秒钟30帧
	def Update(self):
		pass

	def OnTableBtnTouchUp(self, args):
		"""
		打开创建选择界面
		"""
		clientApi.PushScreen(modConfig.ModName, "SetDebugDrawing")
