# -*- coding: utf-8 -*-
import mod.client.extraClientApi as clientApi
from mod_log import logger
from functools import wraps
from DebugDrawingScripts.modCommon import modConfig
# from DebugDrawingScripts.modCommon import DebugDrawingCfg

screen_node = clientApi.GetScreenNodeCls()
view_binder = clientApi.GetViewBinderCls()

compFactory = clientApi.GetEngineCompFactory()
minecraftEnum = clientApi.GetMinecraftEnum()
levelId = clientApi.GetLevelId()

class CreateBoxDebugDrawing(screen_node):
	def __init__(self, namespace, name, param):
		super(CreateBoxDebugDrawing, self).__init__(namespace, name, param)
		logger.info("========CreateBox UI init========")
		# 获取当前屏幕分辨率
		self._screenSize = compFactory.CreateGame(levelId).GetScreenSize()
		# 获取当前玩家id
		self.mPlayerId = clientApi.GetLocalPlayerId()

		self._mainPanel = "/main_panel"
		# 设置位置Panel
		self._posLeftPanel = self._mainPanel + "/pos_panel/left_panel"
		self._posRightPanel = self._mainPanel + "/pos_panel/right_panel"
		# 设置形状大小Panel
		self._scalePanel = "/main_panel/scale_panel"
		# 设置颜色Panel
		self._colorPanel = self._mainPanel + "/color_panel"
		self._leftPanel = self._colorPanel + "/left_panel"
		self._rightPanel = self._colorPanel + "/right_panel"
		self._movePanel = self._rightPanel + "/movepanel"

		# 按钮移动
		self._btnMovePos = None
		self._markPos = (0, 0)
		# 颜色数据
		self._nowColor = (255, 0, 0)
		self._nowBarColor = (255, 0, 0)


		self._btnDict = {} # 用于存放实例化的按钮object，key为自定义的key（如下面的box），value为按钮对象
		self._editBox = {}
		self._slider = {}
		self._image = {}
		self._btnPath = { # 创建自定义key与按钮路径的映射
			"create": self._mainPanel + "/create",
			"closeBtn": self._mainPanel + "/title_panel/button",
			"colorBtn": self._movePanel + "/move_btn",
			"my_pos_btn": self._posRightPanel + "/my_pos_btn"
		}
		self._editBoxPath = {
			"posX": self._posLeftPanel + "/x_input/edit_box",
			"posY": self._posLeftPanel + "/y_input/edit_box",
			"posZ": self._posLeftPanel + "/z_input/edit_box",
			"scaleX": self._scalePanel + "/scale_x/edit_box",
			"scaleY": self._scalePanel + "/scale_y/edit_box",
			"scaleZ": self._scalePanel + "/scale_z/edit_box",
			"colorR": self._leftPanel + "/red_input_panel/edit_box",
			"colorG": self._leftPanel + "/green_input_panel/edit_box",
			"colorB": self._leftPanel + "/blue_input_panel/edit_box"
		}
		self._sliderPath = {
			"color_change": self._rightPanel + "/slider"
		}
		self._imagePath = {
			"color_image": self._leftPanel + "/color_image",
			"slider_image": self._rightPanel + "/slider/slider_bar_default/transparent_grey"
		}
	
	def init_data(self):
		# 根据配表初始化数据内容
		pass
		

	# Create函数是继承自ScreenNode，会在UI创建完成后被调用
	def Create(self):
		for key, btnPath in self._btnPath.items():
			if key == "colorBtn":
				self.UICreateBtn(self._btnDict, key, btnPath, None, self.OnBtnPressUp, self.OnBtnPressDown, self.OnBtnMove)
			else:
				self.UICreateBtn(self._btnDict, key, btnPath, None, self.OnBtnPressUp) # 批量创建按钮回调，并将创建后的按钮实例保存在self._btnDict字典中。以下同理
		for key, editBoxPath in self._editBoxPath.items():
			editBoxObj = self.GetBaseUIControl(editBoxPath).asTextEditBox()
			if editBoxObj:
				self._editBox.update({key: editBoxObj})
		for key, sliderPath in self._sliderPath.items():
			sliderObj = self.GetBaseUIControl(sliderPath).asSlider()
			if sliderObj:
				self._slider.update({key: sliderObj})
		for key, imagePath in self._imagePath.items():
			imageObj = self.GetBaseUIControl(imagePath).asImage()
			if imageObj:
				self._image.update({key: imageObj})

	def OnBtnPressUp(self, args):
		clickType = args['AddTouchEventParams']['type']
		if clickType == "closeBtn":
			clientApi.PopScreen()
		elif clickType == "colorBtn":
			self.SetPosInSidelineZone(self.GetColorBtn())
			posX, posY = args['TouchPosX'],args['TouchPosY']
			if self._markPos and abs(posX - self._markPos[0]) < 3 and abs(posY - self._markPos[1]) < 3: # 防止误触
				pass
		elif clickType == "my_pos_btn":
			myPos = compFactory.CreatePos(self.mPlayerId).GetPos()
			if myPos:
				self._editBox["posX"].SetEditText(str(myPos[0]))
				self._editBox["posY"].SetEditText(str(myPos[1]))
				self._editBox["posZ"].SetEditText(str(myPos[2]))
		elif clickType == "create":
			# 不输入参数直接创建会报错！
			posX = float(self._editBox["posX"].GetEditText())
			posY = float(self._editBox["posY"].GetEditText())
			posZ = float(self._editBox["posZ"].GetEditText())
			scaleX = float(self._editBox["scaleX"].GetEditText())
			scaleY = float(self._editBox["scaleY"].GetEditText())
			scaleZ = float(self._editBox["scaleZ"].GetEditText())
			colorR = int(self._editBox["colorR"].GetEditText())
			colorG = int(self._editBox["colorG"].GetEditText())
			colorB = int(self._editBox["colorB"].GetEditText())
			try:
				compFactory.CreateDrawing(levelId).AddBoxShape((posX, posY, posZ),(scaleX, scaleY, scaleZ),(colorR, colorG, colorB))
			except:
				logger.info("========AddBoxShape 失败========")
			clientApi.PopScreen()


	def OnBtnPressDown(self, args):
		self._btnMovePos = None
		self._markPos = (args['TouchPosX'], args['TouchPosY'])

	def OnBtnMove(self, args):
		posX = args['TouchPosX']
		posY = args['TouchPosY']
		btn = self.GetColorBtn()
		curPos = btn.GetPosition()
		if self._btnMovePos and btn:
			RelativeX = posX - self._btnMovePos[0]
			RelativeY = posY - self._btnMovePos[1]
			btn.SetPosition((curPos[0] + RelativeX, curPos[1] + RelativeY))
		self._btnMovePos = (posX,posY)
	
	# 继承自ScreenNode的方法，会被引擎自动调用，1秒钟30帧
	def Update(self):
		# 分辨率变化时检测按钮位置是否超出
		screenSize = compFactory.CreateGame(levelId).GetScreenSize()
		if screenSize and screenSize != self._screenSize:
			if self.GetColorBtn():
				self.SetPosInSidelineZone(self.GetColorBtn())
				self._screenSize = screenSize
		# end
		# 拖动条获取拖动面板当前右边颜色
		sliderCtl = self.GetColorChangeSlider()
		if sliderCtl:
			nowBarColor = self.GetRGBFromProgress(sliderCtl.GetSliderValue())
			if nowBarColor and nowBarColor != self._nowBarColor:
				self._nowBarColor = nowBarColor
				self._image["slider_image"].SetSpriteColor(self.RGB255to1(self._nowBarColor)) # 设置滑动条背景颜色
				
		# end
		# 获取按钮位置当前颜色
		updateRgb = self.GetColorByBtnPos(self.GetColorBtn(), (0, 0, 0), self._nowBarColor)
		if updateRgb and updateRgb != self._nowColor:
			self._nowColor = updateRgb
		# end
		# 设置输出
		if self._image and "color_image" in self._image:
			self._image["color_image"].SetSpriteColor(self.RGB255to1(self._nowColor))
		if self._editBox and "colorR" in self._editBox:
			self._editBox["colorR"].SetEditText(str(self._nowColor[0]))
		if self._editBox and "colorG" in self._editBox:
			self._editBox["colorG"].SetEditText(str(self._nowColor[1]))
		if self._editBox and "colorB" in self._editBox:
			self._editBox["colorB"].SetEditText(str(self._nowColor[2]))
		# end

	# 数据绑定
	@view_binder.binding(view_binder.BF_BindColor, "#set_color2")
	def ReturnSetEndColor(self):
		list(self.RGB255to1(self._nowBarColor))
		return [1.0, 0.0, 0.0, 1.0]
	

	# region 方法
	def RGB255to1(self, rgb):
		"""
		将 (R,G,B) 从 0~255 转为 0~1
		输入: (r, g, b) - 每个分量 0~255
		输出: (r, g, b) - 每个分量 0~1
		"""
		r, g, b = rgb
		return (r / 255.0, g / 255.0, b / 255.0)

	def GetRGBFromProgress(self, x):
		"""
		输入: x ∈ [0,1]
		输出: (r,g,b) ∈ [0,255]
		颜色会从红 → 黄 → 绿 → 青 → 蓝 → 品红 → 红 循环一圈
		"""
		import colorsys
		
		# 限制范围
		x = max(0.0, min(1.0, x))
		
		# Hue 从 0 到 1 对应 0~360°
		h = x  # 色相环比例
		s = 1.0  # 饱和度
		v = 1.0  # 亮度
		# 转换到 RGB（colorsys 返回的是 0~1）
		r, g, b = colorsys.hsv_to_rgb(h, s, v)
		
		# 转成 0~255 整数
		return (int(r * 255), int(g * 255), int(b * 255))
	
	def GetColorByBtnPos(self, btnCtl, startColor=(0, 0, 0), endColor=(255, 0, 0)):
		if btnCtl:
			size = btnCtl.GetSize()
			movePanelSize = self.GetSize(self._movePanel)
			pos = btnCtl.GetPosition()
			movePanelPos = self.GetPosition(self._movePanel)

			# 按钮中心点的绝对位置
			center = (pos[0] + size[0] / 2, pos[1] + size[1] / 2)
			# 相对坐标（0~1）
			relX = (center[0] - movePanelPos[0]) / movePanelSize[0]
			relX = max(0.0, min(1.0, relX))
			# 插值计算
			r = int(startColor[0] + (endColor[0] - startColor[0]) * relX)
			g = int(startColor[1] + (endColor[1] - startColor[1]) * relX)
			b = int(startColor[2] + (endColor[2] - startColor[2]) * relX)
			return (r, g, b)

	def GetColorBtn(self):
		if self._btnDict and "colorBtn" in self._btnDict:
			return self._btnDict["colorBtn"]
		return None
	
	def GetColorChangeSlider(self):
		if self._slider and "color_change" in self._slider:
			return self._slider["color_change"]
		return None

	def SetPosInSidelineZone(self, btnCtl):
		"""
		让按钮中心不超出边缘中心
		"""
		size = btnCtl.GetSize()
		movePanelSize = self.GetSize(self._movePanel)
		pos = btnCtl.GetPosition()
		# 按钮中心点
		center = (pos[0] + size[0] / 2, pos[1] + size[1] / 2)
		# 约束中心点在安全区内
		clampedCenter = tuple(max(min(center[n], movePanelSize[n]), 0)for n in(0, 1))
		# 根据中心点重新计算左上角位置
		pos = (clampedCenter[0] - size[0] / 2,clampedCenter[1] - size[1] / 2)
		btnCtl.SetPosition(pos)
		return pos

	def UICreateBtn(self, btnDict, btnKey, path, param=None, upFunc=None, downFunc=None, moveFunc=None):
		if param is None:
			param = {"isSwallow": True, "type": btnKey}
		if type(btnDict) != dict:
			btnDict = {}
		if type(btnKey) != str:
			return
		btnDict.update({btnKey: self.GetBaseUIControl(path).asButton()})
		btnDict[btnKey].AddTouchEventParams(param)
		if upFunc is not None:
			btnDict[btnKey].SetButtonTouchUpCallback(upFunc)
		if downFunc is not None:
			btnDict[btnKey].SetButtonTouchDownCallback(downFunc)
		if moveFunc is not None:
			btnDict[btnKey].SetButtonTouchMoveCallback(moveFunc)
	# enregion

