# -*- coding: utf-8 -*-

import client.extraClientApi as clientApi
ClientSystem = clientApi.GetClientSystemCls()
from DebugDrawingScripts.modCommon import modConfig

class DebugDrawingClientSystem(ClientSystem):
	def __init__(self, namespace, systemName):
		ClientSystem.__init__(self, namespace, systemName)
		self.ListenEvent()

	def ListenEvent(self):
		namespace = clientApi.GetEngineNamespace()
		system_name = clientApi.GetEngineSystemName()
		self.ListenForEvent(namespace, system_name, "UiInitFinished", self, self.init_all_ui)

	def init_all_ui(self, data):
		# 创建hud UI
		clientApi.RegisterUI(modConfig.ModName, "openDebugDrawingGUI", "DebugDrawingScripts.modClient.ui.openDebugDrawingGUI.OpenDebugDrawingGUI", "openDebugDrawingGUI.main")
		clientApi.CreateUI(modConfig.ModName, "openDebugDrawingGUI", {"inputMode": 0})
		# 创建 绘制选项UI
		clientApi.RegisterUI(modConfig.ModName, "SetDebugDrawing", "DebugDrawingScripts.modClient.ui.setDebugDrawing.SetDebugDrawing", "SetDebugDrawing.main")
		# 创建形状
		clientApi.RegisterUI(modConfig.ModName, "createBoxDebugDrawing", "DebugDrawingScripts.modClient.ui.createBoxDebugDrawing.CreateBoxDebugDrawing", "createBoxDebugDrawing.main")